create table PBS_PARAM (
    PARAM	varchar2(32),
    VALUE	varchar2(256),
    unique ( PARAM )
);

create table PBS (
    IPADDR	varchar2(64),
    POPUSER	varchar2(128),
    TIME	number(10)	not NULL,
    unique ( IPADDR, POPUSER ) on conflict replace
);

create table USERMAP (
    POPUSER	varchar2(128),
    MAILADDR	varchar2(128),
    STATUS	number(2)	not NULL,
    unique ( POPUSER, MAILADDR )
);

create table ACCESSMAP (
    IPADDR	varchar2(64),
    MAILADDR	varchar2(128),
    TYPE	number(2)	not NULL,
    unique ( IPADDR, MAILADDR )
);

create view V_PBS as
select PBS.IPADDR, USERMAP.MAILADDR, PBS.TIME
  from PBS, USERMAP
 where PBS.POPUSER = USERMAP.POPUSER and USERMAP.STATUS = 1
    or PBS.IPADDR in ( select IPADDR from ACCESSMAP where TYPE = 1 )
union all
select ACCESSMAP.IPADDR, USERMAP.MAILADDR, PBS.TIME
  from PBS, USERMAP, ACCESSMAP
 where ACCESSMAP.TYPE = 2 
   and PBS.POPUSER = USERMAP.POPUSER and USERMAP.STATUS = 1
   and USERMAP.MAILADDR = ACCESSMAP.MAILADDR;
