#!%PHP%
<?php

$dsn = array('phptype' => 'sqlite',
	     'database' => '%DATABASE%');

require_once 'DB.php';

$debug = false;
if($argc >1 && $argv[1] == '-v') $debug = true;

openlog('pbsselect', LOG_ODELAY | LOG_PID, LOG_MAIL);
function debuglog($s){
    global $debug;
    if($debug) syslog(LOG_INFO, $s);
}

function smtpd_access_policy($db, $attr){
    global $sth, $expire;

    if(!isset($attr['request'])){
	syslog(LOG_INFO, 'request type not specified');
	return false;
    }
    if($attr['request'] != 'smtpd_access_policy'){
	syslog(LOG_INFO, 'unrecognized request type: '.$attr['request']);
	return false;
    }
    if(!isset($attr['client_address']) || !isset($attr['sender'])){
	syslog(LOG_INFO, 'insufficient request');
	return false;
    }
    $res =& $db->execute($sth, array($attr['client_address'],
				     $attr['sender'],
				     time() - $expire));
    if(DB::isError($res)){
	syslog(LOG_INFO, 'sql select failed: '.$res->getMessage());
	exit(1);
    }
    $r = $res->fetchRow();
    if(DB::isError($r)){
	syslog(LOG_INFO, 'sql select failed: '.$r->getMessage());
	exit(1);
    }
    return $r[0] ? true : false;
}


$db = DB::connect($dsn);
if(DB::isError($db)){
    syslog(LOG_INFO, "connect failed: ".$db->getMessage());
    exit(1);
}

// delete old records
$expire = $db->getOne("select VALUE from PBS_PARAM where PARAM = 'expire';");
if(DB::isError($expire)){
    syslog(LOG_INFO, "select failed: ".$expire->getMessage());
    exit(1);
}
$res =& $db->query("delete from PBS
    where TIME < ".(time() - $expire)."
       or POPUSER not in (select POPUSER from USERMAP);");
if(DB::isError($res)){
    syslog(LOG_INFO, "delete failed: ".$res->getMessage());
}

// main
$sth = $db->prepare("select count(*) from V_PBS
    where IPADDR = ? and MAILADDR = ? and TIME > ?;");
if(DB::isError($sth)){
    syslog(LOG_INFO, "prepare failed: ".$sth->getMessage());
    exit(1);
}
$attr = array();
while(1){
    $line = fgets(STDIN, 1024);
    if(!isset($line) || $line === false) break;
    $line = trim($line);
    debuglog("input: $line");
    $s = explode('=', $line, 2);
    if(isset($s[1])){
	$attr[$s[0]] = $s[1];
    } elseif ($line == ''){
	if(smtpd_access_policy($db, $attr)){
	    print "action=OK\n\n";
	    debuglog("output: action=OK");
	} else {
	    print "action=DUNNO\n\n";
	    debuglog("output: action=DUNNO");
	}
	$attr = array();
    } else {
	syslog(LOG_INFO, "ignoring garbage: $line");
    }
}
syslog(LOG_INFO, "end of input -- exiting");

?>
