#!/bin/sh
#
# SONY DSC-HX5V(とその後継機種?)用 GPS アシストデータ更新スクリプト for MacOSX

# メモリカードのボリューム名
volname="Untitled"

:<<___
使い方
1) メモステないしは SD カードのボリューム名を調べて、
   上の volname="..." の部分を書き換える
2) そのボリュームに /PRIVATE/SONY/GPS というフォルダが存在していなければ
   作成する(自動では作成しません)
3) メモリカードを認識している状態でこのスクリプトを実行すると、
   GPS アシストデータが更新される

おまけ)
   更新の成功/失敗を Growl で通知できます。
   Growl-x.x.dmg の中に Extras/growlnotify/growlnotify というファイルが
   あるので、それを /usr/local/bin というフォルダを作ってその中にコピーして
   おいてください(growl をふつーにインストールしただけでは入りません)。
___

url="http://control.d-imaging.sony.co.jp/GPS/assistme.dat"
growlnotify="/usr/local/bin/growlnotify"
update_interval="1d"	# 1 day

case "$#" in
1)  volname="$1";;
esac

dir="/Volumes/$volname/PRIVATE/SONY/GPS"
filename="`basename $url`"
tmpfile="/tmp/$filename.$$"

notify(){
    if [ -x "$growlnotify" ]; then
	$growlnotify -a iPhoto -m "$*" -t "DSC-HX5V"
    fi
}

if [ -d "$dir" ]; then
    if [ -f "$dir/$filename" ]; then
	touch -t `date -v -"$update_interval" +%y%m%d%H%M` $tmpfile
	if [ "$tmpfile" -ot "$dir/$filename" ]; then
	    notify "GPSアシストデータは最新です"
	    test -f "$tmpfile" && rm -f "$tmpfile"
	    exit
	fi
    fi
    if curl -s -o "$tmpfile" "$url" && test -s "$tmpfile" && cp -f "$tmpfile" "$dir/$filename"; then
	notify "GPSアシストデータを更新しました"
    else
	notify "GPSアシストデータの更新に失敗しました"
    fi
    test -f "$tmpfile" && rm -f "$tmpfile"
fi
