<?php
require 'rss.inc';

$url = 'http://news.google.co.jp/?ned=jp';

function convstr($s){
    $s = strip_tags($s);
    $s = strtr($s, array('<'    => '&lt;',
                         '>'    => '&gt;',
                         '"'    => '&quot;',
                         '\''   => '&#39;', //'&apos;',
			 '&nbsp;' => ' ',
			 ));
    $s = preg_replace('/&(?!(amp|lt|gt|quot|#\d+);)/', '&amp;', $s);
    return trim($s);
}

if(!empty($_SERVER["REQUEST_METHOD"])){
    // GET/POST
    $args =& $_REQUEST;
    $cli = 0;
} else{
    // comamndline
    include 'Console/Getopt.php';
    $tmp  = Console_Getopt::getopt($argv, NULL, array('level=', 'topic=', 'q=',
						      'ls=', 'ver='));
    $args = array();
    foreach($tmp[0] as $val){
	$args[substr($val[0], 2)] = $val[1];
    }
    $cli = 1;
}

$ls = 15;
$level = 1;
$img = false;
$q = '';
$ver = '1.0';
mb_detect_order('EUC-JP,eucJP-win,UTF-8,Shift-JIS,SJIS-win,ISO-2022-JP');

foreach($args as $k => $v){
    switch($k){
    case 'ls':
	$ls = (int)$v;
	if($ls <= 0) $ls = 15;
	if($ls >= 500) $ls = 500;
	break;
    case 'level':
	$level = (int)($v{0});
	if(strstr($v, 'i')) $img = TRUE;
	break;
    case 'topic':
	switch($v){
	case 'y': case 'w': case 'b': case 'p':
	case 's': case 'e': case 't':
	    $url .= '&topic='.$v;
	}
	break;
    case 'q':
	if($v != ''){
	    $q = urlencode(mb_convert_encoding(urldecode($v), 'UTF-8', mb_detect_order()));
	    $url .= '&q='.$q;
	}
	break;
    case 'ver':
	switch($v){
	case '0.9': case '0.91': case '0.92': case '0.93':
	case '1.0': case '2.0':
	    $ver = $v;
	}
	break;
    }
}

function rss_googlenews($buf){
    global $level, $img;
    global $ver, $ls;
    global $url;

    $rss = new RSS;
    $rss->version = $ver;
    $rss->language = 'ja';
    $rss->encoding = 'UTF-8';
    $rss->channel['link'] = convstr($url);

    //mb_internal_encoding("SJIS");
    mb_internal_encoding("UTF-8");
    
    $a = preg_split('#<a[^>]*href="#', $buf);
    preg_match('#<title>(.*)</title>#', $a[0], $m);
    $rss->channel['title'] = convstr($m[1]);
    foreach($a as $k => $v){
	if(!preg_match('#^https?:#', $v) ||
	   preg_match('#^http://\w+\.google\.(co\.jp|com)/#', $v)){
	    continue;
	}
	$v = preg_replace('%<SCRIPT.*%', '', $v);
	preg_match('%([^"]*)"([^>]*)>(.*)</a>(.*)%', $v, $m);
	$b = FALSE;
	$l = 2;
	//if(preg_match('%^<b>%', $m[3])) $l = 1;
	if(preg_match('%id=r-[-0-9_]+$%', $m[2])) $l = 1;
	if(preg_match('%^<nobr>%', $m[3])){ $l = 3; $m[4] = $m[3]; }
	if(preg_match('%^<img%', $m[3])){ $b = TRUE; $l = 4; $m[4] = $m[3]; }
	$m[4] = preg_replace('%<a [^>]*href=[^>]*>.*%', '', $m[4]);
	if($level >= $l || ($img == TRUE && $b == TRUE)){
	    $rss->items[] = array('link' => convstr($m[1]),
				  'title' => convstr($m[3]),
				  'description' => convstr($m[4]));
	//print_r($m);
	    $ls--;
	}
	if(!$ls) break;
    }
    return $rss->as_string();
}

if($q){
    $url .= '&ie=UTF-8';
}
$file = @file($url.'&num='.$ls.'&oe=UTF-8', 'r');

if($file){
    $out = rss_googlenews(join("\n", $file));
    if(!$cli){
	Header("Content-Type: application/xml; charset=UTF-8");
	Header("Cache-Control: max-age=3600");
	Header("Content-Length: ".strlen($out));
    }
    print $out;
} else{
    $rss = new RSS;
    $rss->channel['description'] = 'Error!';
    $rss->items[] = array('link' => convstr($url), 'title' => 'Error!');
    if(!$cli) Header("Content-Type: application/xml; charset=$rss->encoding");
    print $rss->as_string();
}

?>
