<?php

// time zone offset
define('TZD', '+09:00');

class RSS {
    var $version;
    var $encoding;
    var $channel;
    var $items;
    var $xsl;
    var $css;

    /* constructor */
    function RSS($v = "1.0", $e = "UTF-8",
		 $c = array('title' => '', 'link' => '', 'description' => ''),
		 $i = array()){
	$this->version = $v;
	$this->encoding = $e;
	$this->channel = $c;
	$this->items = $i;
	$this->xsl = '';
	$this->css = '';
    }

    function channel($array){
	$this->channel = $array;
    }

    function add_item($array){
	array_push($this->items, $array);
    }

    function image($array){
	$this->image = $array;
    }

    function textinput($array){
	$this->textinput = $array;
    }

    function as_string(){
	switch($this->version){
	case '0.91':
	case '0.92':
	case '0.93':
	case '2.0':
	    $ret = $this->as_string091($this->version);
	    break;
	case '0.9':
	case '1.0':
	    $ret = $this->as_string100($this->version);
	    break;
	default:
	    $ret =  FALSE;
	    break;
	}
	if($ret){
	    // UTF-8  EUC-JP ʤ PHP  XML ʸ̾Τפ뤱ɡ
	    // SJIS  Shift_JIS ʤƤΤȤþä
	    return mb_convert_encoding($ret, $this->encoding);
	} else{
	    return FALSE;
	}
    }

    function as_string091($ver = '0.91'){
	switch($ver){
	case '0.91':
	    $dtd = "<!DOCTYPE rss PUBLIC \"-//Netscape Communications//DTD RSS 0.91//EN\"\n    \"http://my.netscape.com/publish/formats/rss-0.91.dtd\">\n";
	    // required: description<1000, language, link<500, title<100
	    if(empty($this->description)){
		$desc = '';
	    } else{
		$desc = substr($this->description, 0, 999);
	    }
	    if(empty($this->language)) $this->language = 'ja';
	    break;
	case '0.92':
	case '0.93':
	case '2.00':
	    $dtd = '';
	    break;
	}
	$str = "<?xml version=\"1.0\" encoding=\"$this->encoding\" ?>\n";
	if(!empty($this->xsl)){
	    $str .= "<?xml-stylesheet type=\"text/xsl\" href=\"$this->xsl\"?>\n";
	}
	if(!empty($this->css)){
	    $str .= "<?xml-stylesheet type=\"text/css\" href=\"$this->css\"?>\n";
	}
	$str .=<<<EOD
$dtd<rss version="$ver">
 <channel>
  <language>{$this->language}</language>
  <title>{$this->channel['title']}</title>
  <link>{$this->channel['link']}</link>
  <description>{$this->channel['description']}</description>

EOD;
	$num = 0;
	foreach($this->items as $i){
	    if($ver == '0.91' && ++$num > 15) break;
	    $str .= <<<EOD

  <item>
   <title>{$i['title']}</title>
   <link>{$i['link']}</link>

EOD;
	    if(!empty($i['description'])) $str .= "   <description>{$i['description']}</description>\n";
	    $str .= "  </item>\n";
	}
	$str .= <<<EOD
 </channel>
</rss>

EOD;
	return $str;
    }

    function as_string100($ver = '1.0'){
	switch($ver){
	case '0.9':
	    $xmlns = 'http://my.netscape.com/rdf/simple/0.9/';
	    $about = '';
	    break;
	case '1.0':
	    $xmlns = 'http://purl.org/rss/1.0/';
	    $about = " rdf:about=\"{$this->channel['link']}\"";
	    break;
	}
	$lang = '';
	if(!empty($this->language)) $lang = " xml:lang=\"$this->language\"\n";

	$str = "<?xml version=\"1.0\" encoding=\"$this->encoding\" ?>\n";
	if(!empty($this->xsl)){
	    $str .= "<?xml-stylesheet type=\"text/xsl\" href=\"$this->xsl\"?>\n";
	}
	if(!empty($this->css)){
	    $str .= "<?xml-stylesheet type=\"text/css\" href=\"$this->css\"?>\n";
	}
	$str .= <<<EOD
<rdf:RDF
 xmlns="$xmlns"
 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
 xmlns:dc="http://purl.org/dc/elements/1.1/"
$lang>

 <channel$about>
  <title>{$this->channel['title']}</title>
  <link>{$this->channel['link']}</link>
  <description>{$this->channel['description']}</description>

EOD;
	if($ver == '1.0'){
	    $str .= "  <items>\n   <rdf:Seq>\n";
	    foreach($this->items as $i){
		$str .= "    <rdf:li rdf:resource=\"{$i['link']}\" />\n";
	    }
	    $str.= <<<EOD
   </rdf:Seq>
  </items>

EOD;
	}
	$str .= " </channel>\n";
	foreach($this->items as $i){
	    switch($ver){
	    case '0.9':
		$about .= '';
		break;
	    case '1.0':
		$about = " rdf:about=\"{$i['link']}\"";
		break;
	    }
	    $str .= <<<EOD

  <item$about>
   <title>{$i['title']}</title>
   <link>{$i['link']}</link>

EOD;
	    if(!empty($i['description'])) $str .= "   <description>{$i['description']}</description>\n";
	    if(!empty($i['creator'])) $str .= "   <dc:creator>{$i['creator']}</dc:creator>\n";
	    if(!empty($i['subject'])) $str .= "   <dc:subject>{$i['subject']}</dc:subject>\n";
	    if(!empty($i['date'])) $str .= "   <dc:date>{$i['date']}</dc:date>\n";

	    $str .= "  </item>\n";
	}
	$str .= "</rdf:RDF>\n";
	return $str;
    }
} // class RSS end.

// http://www.w3.org/TR/NOTE-datetime
function epoch_to_w3cdtf($time, $tzd = TZD){
    return strftime("%Y-%m-%dT%H:%M:%S$tzd", $time);
}


// sample
/*
mb_internal_encoding("EUC-JP");
$rss = new RSS;
$rss->channel(array('title' => "ۤۤ",
		    'link' => "http://hoge.org",
		    'description' => "դդ"));
$rss->add_item(array('title' => 'title',
		     'link' => "http://aaaa",
		     'description' => 'desc'));
$rss->add_item(array('title' => 'TITLE',
		     'link' => "http://bbb"));
$rss->add_item(array('title' => 'xxx',
		     'link' => 'url',
		     'description' => 'aaaa',
		     'creator' => 'author',
		     'subject' => 'subject',
		     'date' => epoch_to_w3cdtf(time())));
*/
/*
$rss = new RSS('0.91', 'EUC-JP',
	       array('title' => "ۤۤ",
		     'link' => "http://hoge.org",
		     'description' => "դդ"),
	       array(array('title' => 'title',
			   'link' => "http://aaaa",
			   'description' => 'desc'),
		     array('title' => 'TITLE',
			   'link' => "http://bbb",
			   'description' => 'DESC')));
*/
/* print $rss->as_string(); */
?>
