<?php

require 'rss.inc';
$baseurl = 'http://slashdot.jp/';

function convstr($s){
    $s = strip_tags($s);
    $s = strtr($s, array('<'    => '&lt;',
                         '>'    => '&gt;',
                         '"'    => '&quot;',
                         '\''   => '&#39;'));
    $s = preg_replace('/&(?!(amp|lt|gt|quot|#\d+);)/', '&amp;', $s);
    return trim($s);
}

$rss = new RSS;
$rss->version = '1.0';
$rss->language = 'ja';
$rss->channel['link'] = $baseurl;
mb_internal_encoding("UTF-8");

$fp = @fopen($baseurl, 'r');
if(!$fp){
    $rss->channel['description'] = 'Error!';
    $rss->items[] = array('link' => $baseurl, 'title' => 'Error!');
    Header("Content-Type: application/xml; charset=$rss->encoding");
    print $rss->as_string();
    exit;
}

$id = 0;
$item = array();
while(!feof($fp)){
    $buf = trim(fgets($fp, 4096));

    if(preg_match('/^<!-- start template: ID (\d+),/', $buf, $m)){
	$id = (int)$m[1];
    }
    if(preg_match('/^<!-- end template: ID \d+,/', $buf)){
	if($id == 169){
	    $item['description'] = convstr($item['description']);
	    //$item['description'] = '<![CDATA['.$item['description'].']]>';
	    $rss->items[] = $item;
	    $item = array();
	}
	$id = 0;
    }

    switch($id){
    case 88: /* dispStory */
	if(preg_match('/^<tr/', $buf)){
	    $item['title'] = convstr($buf);
	    continue;
	}
	if(preg_match('/(\d+)年(\d+)月(\d+)日  ?(\d+)時(\d+)分の掲載/', $buf, $m)){
	    $item['date'] = sprintf('%04d-%02d-%02dT%02d:%02d+09:00', $m[1], $m[2], $m[3], $m[4], $m[5]);
	    continue;
	}
	if(preg_match('/(.*)による$/', $buf, $m)){
	    $item['creator'] = convstr($m[1]);
	    continue;
	}
	if(preg_match('/<br>(.*部門)より．$/', $buf, $m)){
	    $item['subject'] = convstr($m[1]);
	    continue;
	}
	if(preg_match('/<div class="introtext">/', $buf)){
	    $flag = 1;
	    continue;
	}
	if($flag && preg_match('/<\/div>/', $buf)){
	    $flag = 0;
	}
	if($flag){
	    $item['description'] .= $buf;
	}
	break;
    case 169: /* storylink */
	if(preg_match('#<A HREF="(http:)?//slashdot\.jp/([^/]*)/(.*)\.shtml"><strong>#', $buf, $m)){
	    if($m[2] == 'articles'){
		$item['link'] = $baseurl.'article.pl?sid='.$m[3];
	    } else{
		$item['link'] = $baseurl.$m[2].'/article.pl?sid='.$m[3];
	    }
	}
	break;
    case 114: /* getOlderStories */
	if(preg_match('#<A HREF="(http:)?//slashdot\.jp/([^/]*)/(.*)\.shtml">(.*)</A>#', $buf, $m)){
	    if($m[2] == 'articles'){
		$rss->add_item(array('title' => convstr($m[4]),
				     'link' => $baseurl.'article.pl?sid='.$m[3]));
	    } else {
		$rss->add_item(array('title' => convstr($m[4]),
				     'link' => $baseurl.$m[2].'/article.pl?sid='.$m[3]));
	    }
	}
	break;
    default:
	if(preg_match('/<title>([^<]+)<\/title>/', $buf, $m)){
	    $rss->channel['title'] = convstr($m[1]);
	}
	break;
    }
}

$out = $rss->as_string();
Header("Content-Type: application/xml; charset=$rss->encoding");
Header("Content-Length: ".strlen($out));
print $out;

?>
